package be.ac.ulb.mlg.utils;


/*
 * The MIT License (MIT)
 * 
 * Copyright (c) 2013 Jean-Sebastien Lerat (Jean-Sebastien.Lerat@ulb.ac.be)
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/**
 * 
 * @author Jean-Sebastien Lerat (Jean-Sebastien.Lerat@ulb.ac.be)
 * @version 1.00, 30/08/2013
 */

/**
 * Matrix discretization interface
 *
 */
public interface Discretizer {
	public static enum Mode{ROW_WISE,COLUMN_WISE,GLOBAL}
	/**
	 * TODO
	 * @return
	 */
	public boolean requirePreprocessing();
	/**
	 * TODO
	 * @param matrix
	 */
	public void preprocess(double[][] matrix);
	/**
	 * Transform value of a double matrix to integer but preserve the structure (double matrix)
	 * @param matrix The input matrix to be normalized
	 * @return The normalized matrix
	 */
	public double[][] discretize(double[][] matrix);
	/**
	 * Know if the discretization owns a native implementation
	 * @return True if the discretizer is also natively implemented
	 */
	public boolean hasNativeImplementation() ;
}
