package be.ac.ulb.mlg.utils.measure;

/*
 * The MIT License (MIT)
 * 
 * Copyright (c) 2013 Jean-Sebastien Lerat (Jean-Sebastien.Lerat@ulb.ac.be)
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/**
 * 
 * @author Jean-Sebastien Lerat (Jean-Sebastien.Lerat@ulb.ac.be)
 * @version 1.00, 24/06/2013
 * @see <a href="http://dx.doi.org/10.2307/1412159">An Ordination of the Upland Forest Communities of Southern Wisconsin (J. Roger Bray and J. T. Curtis)</a>
 */

import be.ac.ulb.mlg.utils.Measure;
import static java.lang.Math.min;

/**
 * BrayCurtis(X,Y) = 1-2*W/(sum(X)+sum(Y)), with W = sum_i[ min(x_i,y_i)]
 */
public class BrayCurtis implements Measure{
	@Override
	public double measure(final double[] A, final double[] B,boolean[] computable){
		double min = 0.0,sum = 0.0;
		int index;

		if(computable != null){
			for(index=0;index<A.length;index++)
				if(computable[index]){
					min += min(A[index],B[index]);
					sum += A[index]+B[index];
				}
		}else{
			for(index=0;index<A.length;index++){
				min += min(A[index],B[index]);
				sum += A[index]+B[index];
			}
		}
		if((sum>0?sum:-sum)<1e-16)return ERROR_VALUE;
		return 1.0 - 2.0 * min / sum;
	}
	@Override
	public boolean hasNativeImplementation() {
		return true;
	}
	@Override
	public boolean requireDataTransformation() {
		return false;
	}

	@Override
	public void transform(double[][] data) {
		//nothnig to do
	}
}
