package be.ac.ulb.mlg.utils.measure.entropy;

/*
 * The MIT License (MIT)
 * 
 * Copyright (c) 2013 Jean-Sebastien Lerat (Jean-Sebastien.Lerat@ulb.ac.be)
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/**
 * 
 * @author Jean-Sebastien Lerat (Jean-Sebastien.Lerat@ulb.ac.be)
 * @version 1.00, 30/08/2013
 */

import be.ac.ulb.mlg.utils.measure.Entropy;

import static java.lang.Math.log;

/**
 * The classic empirical entropy estimate of Uniform probability distribution.
 */

public class EmpiricalEntropy extends Entropy{
	private final double pseudoCount;
	
	/**
	 * Constructor with no pseudo count
	 */
	public EmpiricalEntropy(){
		this(0.0);
	}
	/**
	 * Constructor that use a pseudo count value added to occurrences
	 * @param pseudoCount The pseudo count value
	 */
	public EmpiricalEntropy(double pseudoCount){
		this.pseudoCount = pseudoCount;
	}
	@Override
	public double entropy(double[] frequencies, int distinctValues,int numberOfValues) {
		double entropy = 0.0; 
		for(double freq:frequencies){
			freq	= (freq+pseudoCount)/numberOfValues;
			if(freq > 0.0)
				entropy += freq * log(freq);
		}
		return -entropy;
	}
	@Override
	public boolean hasNativeImplementation(){
		return true;
	}
}
