package be.ac.ulb.mlg.utils;

/*
 * The MIT License (MIT)
 * 
 * Copyright (c) 2013 Jean-Sebastien Lerat (Jean-Sebastien.Lerat@ulb.ac.be)
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/**
 * 
 * @author Jean-Sebastien Lerat (Jean-Sebastien.Lerat@ulb.ac.be)
 * @version 1.00, 24/06/2013
 */

public interface Measure{
	/**
	 * Value representing an error during measuring
	 */
	public static final double ERROR_VALUE	= Double.NaN;
	/**
	 * Compute the measure between two data vectors
	 * @param a The first data vector
	 * @param b The second data vector
	 * @param computable Boolean vector set to true except for indexes they must be ignored during the measurement
	 * @return The measure between a and b
	 */
	public double measure(final double[] a, final double[] b,boolean[] computable);
	/**
	 * Know if the measure owns a native implementation
	 * @return True if the measure is also natively implemented
	 */
	public boolean hasNativeImplementation();
	/**
	 * Know if the measure need to transform input data (input data are copied to be preserved)
	 * @return True if the input data require some transformation
	 */
	public boolean requireDataTransformation();
	/**
	 * The transformation method called before measurement
	 * @param data An input data vector to be measured
	 */
	public void transform(double[][] data);
}
