package be.ac.ulb.mlg.utils.measure;

/*
 * The MIT License (MIT)
 * 
 * Copyright (c) 2013 Jean-Sebastien Lerat (Jean-Sebastien.Lerat@ulb.ac.be)
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/**
 * 
 * @author Jean-Sebastien Lerat (Jean-Sebastien.Lerat@ulb.ac.be)
 * @version 1.00, 24/06/2013
 * @see <a href="http://dx.doi.org/10.1109%2F18.61115">Divergence measures based on the shannon entropy</a>
 */

import static be.ac.ulb.mlg.utils.MeasureUtils.log;
import be.ac.ulb.mlg.utils.Measure;

public class JensenShannon implements Measure{
	private final double pseudoCount;
	/**
	 * TODO
	 */
	public JensenShannon(final double pseudoCount){
		this.pseudoCount = pseudoCount;
	}
	/**
	 * TODO
	 */
	public JensenShannon(){
		this(0.0);
	}
	
	@Override
	public double measure(final double[] A, final double[] B,boolean[] computable){
		double KL = 0.0;
		double M;
		int index;
		
		if(computable != null){
			for(index=0;index<A.length;index++){
				if(computable[index]){
					M = (A[index]+B[index])/2.0;
					KL += A[index]*log(A[index]/M+pseudoCount) + B[index]*log(B[index]/M+pseudoCount);
				}
			}
		}else{
			for(index=0;index<A.length;index++){
				M = (A[index]+B[index])/2.0;
				KL += A[index]*log(A[index]/M+pseudoCount) + B[index]*log(B[index]/M+pseudoCount);
			}
		}
		
		if(Double.isInfinite((KL<0.0?-KL:KL))) return ERROR_VALUE;
		KL /= 2.0;
		
		return KL;
	}
	@Override
	public boolean hasNativeImplementation() {
		return true;
	}
	@Override
	public boolean requireDataTransformation() {
		return false;
	}

	@Override
	public void transform(double[][] data) {
		//nothnig to do
	}
}
