package be.ac.ulb.mlg.utils.measure;

/*
 * The MIT License (MIT)
 * 
 * Copyright (c) 2013 Jean-Sebastien Lerat (Jean-Sebastien.Lerat@ulb.ac.be)
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/**
 * 
 * @author Jean-Sebastien Lerat (Jean-Sebastien.Lerat@ulb.ac.be)
 * @version 1.00, 24/06/2013
 * @see <a href="http://dx.doi.org/10.1214%2Faoms%2F1177729694">On Information and Sufficiency</a>
 */

import be.ac.ulb.mlg.utils.Measure;
import static be.ac.ulb.mlg.utils.MeasureUtils.log;

/**
 * Symmetric case ( [ KLD(P|Q) + KLD(Q|P) ] /2 )
 *
 */
public class KullbackLeibler implements Measure{
	private final double pseudoCount;
	/**
	 * TODO
	 */
	public KullbackLeibler(final double pseudoCount){
		this.pseudoCount = pseudoCount;
	}
	/**
	 * TODO
	 */
	public KullbackLeibler(){
		this(0.0);
	}
	
	@Override
	public double measure(final double[] A, final double[] B,boolean[] computable){
		double KL = 0.0;
		int index;
		int count = A.length;// TODO remove
		
		if(computable != null){
			for(index=0;index<A.length;index++)
				if(computable[index]){
					KL += A[index]*log(A[index]/B[index]+pseudoCount) + B[index]*log(B[index]/A[index]+pseudoCount);
				}
				else count--;// TODO remove
		}else{
			for(index=0;index<A.length;index++)
				KL += A[index]*log(A[index]/B[index]+pseudoCount) + B[index]*log(B[index]/A[index]+pseudoCount);
		}
		if(count < 1)return ERROR_VALUE;// TODO remove
		//TODO count<<=1; // uncomment for correct normalization but commented for other implementation compatibility
		//KL /= count;// TODO comment
		if(Double.isInfinite((KL<0?-KL:KL))) return ERROR_VALUE;
		return KL;
	}
	@Override
	public boolean hasNativeImplementation() {
		return true;
	}
	@Override
	public boolean requireDataTransformation() {
		return false;
	}

	@Override
	public void transform(double[][] data) {
		//nothnig to do
	}
}
