package be.ac.ulb.mlg.utils.measure;

/*
 * The MIT License (MIT)
 * 
 * Copyright (c) 2013 Jean-Sebastien Lerat (Jean-Sebastien.Lerat@ulb.ac.be)
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/**
 * 
 * @author Jean-Sebastien Lerat (Jean-Sebastien.Lerat@ulb.ac.be)
 * @version 1.00, 01/05/2013
 * @see <a href="http://dx.doi.org/10.1080%2F14786440109462720">On Lines and Planes of Closest Fit to Systems of Points is Space</a>
 * Prearson Correlation Coefficient (Pearson distance = 1 - Prearson Correlation Coefficient)
 */

import be.ac.ulb.mlg.utils.Measure;
import be.ac.ulb.mlg.utils.MeasureUtils;

public class Pearson implements Measure{

	@Override
	public double measure(final double[] A, final double[] B,boolean[] computable){
		final double avg_A=MeasureUtils.fastMean(A,computable);
		final double avg_B=MeasureUtils.fastMean(B,computable);

		int index;
		
		//compute the squares
		double	square_B	= 0.0,
				mult_AB		= 0.0,
				square_A	= 0.0,
				tmp_A,
				tmp_B;
		
		if(computable != null){
			for(index=0; index<A.length; index++)
				if(computable[index]){
					tmp_A = A[index] - avg_A;
					tmp_B = B[index] - avg_B;
					
					square_A	+= tmp_A*tmp_A;
					square_B	+= tmp_B*tmp_B;
					mult_AB	+= tmp_A * tmp_B;
				}
		}else{
			for(index=0; index<A.length; index++){
					tmp_A = A[index] - avg_A;
					tmp_B = B[index] - avg_B;
					
					square_A	+= tmp_A*tmp_A;
					square_B	+= tmp_B*tmp_B;
					mult_AB	+= tmp_A * tmp_B;
				}
		}
		return mult_AB / MeasureUtils.sqrt(square_A*square_B);
	}
	@Override
	public boolean hasNativeImplementation() {
		return true;
	}
	@Override
	public boolean requireDataTransformation() {
		return false;
	}

	@Override
	public void transform(double[][] data) {
		//nothnig to do
	}
}
